<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CMedia extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"single.gallery"	=> "gallery.htm",
			"single.player"		=> "player.htm",
			"slider"			=> "slider.htm",
			"common"			=> "common.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("media");

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GalleryPage($parent , $module , $count , $page , $link , $type , $return = "html" , $options = array()) {
		global $_LANG_ID;

		$table = $options["table"] ? $options["table"] : $this->tables["plugin:media"];
		$table_lang = $options["table_lang"] ? $options["table_lang"] : $this->tables["plugin:media_lang"];

		if ($parent) {
			if (is_array($parent)) {
				$cond = " AND item_parent in( " . implode("," , $parent) . ") ";
			} else {
				$cond = " AND item_parent = {$parent} ";
			}
		}
		

		switch ($type) {
			case "details":
				$cond .= "AND find_in_set(2 , item_show) ";
			break;

			case "listing":
				$cond .= "AND find_in_set(1 , item_show) ";
			break;
		}

		$this->__init();
		

		$item_count = $this->db->RowCount(
			"	{$table} as c				
			",
			"	WHERE 
				item_parent = {$parent} AND 
				module_id = {$module}	{$cond}"
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"
			SELECT *,r.item_id as id, r.module_id as mid FROM 
				{$table} as r
			LEFT JOIN
				{$table_lang} as l
			ON 
				r.item_id = l.item_id AND 
				l.lang_id = {$_LANG_ID}
			WHERE
				r.module_id = {$module}
				{$cond}
			ORDER BY 
				item_order ASC
			{$limit}			

			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key]["item_id"] = $val["id"];
				$items[$key]["module_id"] = $val["mid"];
				$this->ProcessImage($items[$key] , $link ,  $options);
			}			
		}

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);



	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function OpenGraph($parent , $module ) {
		$gal = $this->Gallery($parent , $module , "" , 3 , "array");
		
		if (is_array($gal)) {
			foreach ($gal as $key => $val) {			
				$this->plugins["seo"]->OpenGraph(array(
					"og:image"	=> $val["source"]
				));
			}
		}
		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access  options = array(
		max		=> 10		// number or elements to show
		path	=> upload/media/
		tn		=> tn|tn2
		before	=> before_content
		after	=> after_content
		display	=> gallery | default, default is popup, but if more then one, will be slider with popup automaticaly 
	)
	*/
	function Gallery($parent , $module , $link , $type , $return = "html" , $options = array()) {
		global $_LANG_ID;

		$table = $options["table"] ? $options["table"] : $this->tables["plugin:media"];
		$table_lang = $options["table_lang"] ? $options["table_lang"] : $this->tables["plugin:media_lang"];

		if ($parent) {
			if (is_array($parent)) {
				$cond = " AND item_parent in( " . implode("," , $parent) . ") ";
			} else {
				$cond = " AND item_parent = {$parent} ";
			}
				
		}
		

		switch ($type) {
			case "details":
				$cond .= "AND find_in_set(2 , item_show) ";
			break;

			case "listing":
				$cond .= "AND find_in_set(1 , item_show) ";
			break;
		}

		$this->__init();

		if ($options["max"]) {
			$limit = " LIMIT {$options[max]} ";
		}
		

		$items = $this->db->QFetchRowArray(
			"
			SELECT *,r.item_id as id, r.module_id as mid FROM 
				{$table} as r
			LEFT JOIN
				{$table_lang} as l
			ON 
				r.item_id = l.item_id AND 
				l.lang_id = {$_LANG_ID}
			WHERE
				r.module_id = {$module}
				{$cond}
			ORDER BY 
				" . ( $options["order"] ? $options["order"] : "item_order ASC") . "
			{$limit}			
			"
		);


		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {
			$items[$key]["item_id"] = $val["id"];
			$items[$key]["module_id"] = $val["mid"];

			$this->ProcessImage($items[$key] , $link ,  $options);
		}			



		if ($return != "html") {
			return $items;
		}
		
		if (!$type) {
			$type = "listing";
		}


		if (count($items) == 1) {
			return $this->Single($items[0] , $type, $options);
		}

		return $this->Slider($items , $type , $options);		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessImage(&$image , $link , $options) {
		global $_CONF;


			$path = $options["path"] ? $options["path"] : "upload/media";
			$tn	= $options["tn"]	? $options["tn"]	:	"large";

			switch ($image["item_type"]) {
				//image
				case "1":
					$image["source"]	= $_CONF["url"] . $path . "/full/{$image[item_id]}.jpg";
					$image["tn"]		= $_CONF["url"] . $path . "/{$tn}/{$image[item_id]}.jpg";
					$image["icon"]		= $this->_t("common")->blockReplace("IconZoom");
				break;

				//yputube
				case "2":
					$image["tn"]		= "https://img.youtube.com/vi/" . $image["item_youtube"] . "/maxresdefault.jpg";
					$image["source"]	= "https://www.youtube.com/watch?v=" . $image["item_youtube"];
					$image["video"]	= $image["item_youtube"];
					$image["icon"]		= $this->_t("common")->blockReplace("IconPlay");
				break;

				//vimeo
				case "3":

					if (!$image["item_vimeo_cover"]) {
						unset($items[$key]);

						$removed = true;
					}
					

					$image["tn"]		= $image["item_vimeo_cover"]; //"https://i.vimeocdn.com/video/" . $image["item_vimeo"] . ".webp";
					$image["source"]	= "https://www.vimeo.com/" . $image["item_vimeo"];
					$image["video"]		= $image["item_vimeo"];
					$image["icon"]		= $this->_t("common")->blockReplace("IconPlay");
				break;

				//local video
				case "4":
					if ($image["item_image"]) {
						$image["tn"]		= $_CONF["url"] . $path . "/{$tn}/{$image[item_id]}.jpg";
					} else {
						$image["tn"]		= $_CONF["url"] . "upload/default-images/video-cover.png";
					}
					
					$image["icon"]		= $this->_t("common")->blockReplace("IconPlay");
					$image["source"]	= $_CONF["url"] . $path . "/video/{$image[item_id]}.mp4";
				break;

				//local audio
				case "5":
					if ($image["item_image"]) {
						$image["tn"]		= $_CONF["url"] . $path . "/{$tn}/{$image[item_id]}.jpg";
						$image["cover"]		= $_CONF["url"] . $path . "/{$tn}/{$image[item_id]}.jpg";
					} else {
						$image["tn"]		= $_CONF["url"] . "upload/default-images/audio-cover.png";
					}
					
					$image["source"]	= $_CONF["url"] . $path . "/audio/{$image[item_id]}.mp3";
					$image["icon"]		= $this->_t("common")->blockReplace("IconPlay");
				break;

				case "6":
					$image["html"] = $image["item_html"];
				break;

				//image
				case "7":
					$image["source"]	= $_CONF["url"] . $path . "/full/{$image[item_id]}.gif";
					$image["tn"]		= $_CONF["url"] . $path . "/full/{$image[item_id]}.gif";
					$image["icon"]		= $this->_t("common")->blockReplace("IconZoom");
				break;

			}

			$copylink = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $image["item_link_type"],
				"link"	=> $image["item_link_link"],
				"module"=> $image["item_link_module"],
				"global"=> $image["item_link_global"]
			));

			
			$image = array(
				"type"				=> $image["item_type"],
				"tn"				=> $image["tn"],
				"source"			=> $image["source"],

				"id"				=> $image["item_id"],

				"title"				=> $image["item_title"],
				"link"				=> $link,

				"main_link"			=> $link ? $link : $image["source"],

				"parent"			=> $image["item_parent"],

				"video"				=> $image["video"],
				"cover"				=> $image["cover"],

				"copyright"			=> $image["item_author"],
				"copyright_link"	=> $copylink,

				"target"			=> $image["item_link_target"],
				"rel"				=> $image["item_link_rel"],

				"_before"			=> $options["before"],
				"_after"			=> $options["after"],

				"html"				=> $image["html"],

				"css"				=> $image["item_css_list"],

				"icon"				=> $image["icon"],


				"item_image_alt"	=> $image["item_image_alt"],

			);
			
			$image["content"]		= $this->Single($image , $type , $options);

	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Single($image , $type = "listing" , $options) {


		$this->__init();

		switch ($options["display"]) {
			default:
			case "gallery":
				$blocks = array(
					"1"	=> "Default",
					"2"	=> "Default",
					"3"	=> "Default",
					"4"	=> "Default",
					"5"	=> "Default",
					"6"	=> "HTML",
					"7"	=> "Default",
				);


				$template = "single.gallery";

			break;

			case "player":
				$blocks = array(
					"1"	=> "Image",
					"2"	=> "Youtube",
					"3"	=> "Vimeo",
					"4"	=> "Video",
					"5"	=> "Audio",
					"6"	=> "HTML",
					"7"	=> "Image",
				);

				$template = "single.player";
			break;
		}
		
		if ($image["link"]) {

			$image["_link"] = $this->_t("common")->blockReplace(
				"Link" , 
				$image
			);
		} else {
			$image["_link"] = "";
		}

		if ($image["title"]) {
			$image["_title"] = $this->_t("common")->blockReplace(
				"Title" , 
				$image
			);
		} else {
			$image["_title"] = "";
		}


		if ($image["copyright"]) {
			$image["copy"] = $this->_t("common")->blockReplace(
				$image["copyright_link"] ? "CopyrightLink" : "Copyright" , 
				$image
			);
		} else {
			$image["copy"] = "";
		}

		$settings = array(
			"video_autoplay"	=> $this->tpl_module["settings"]["set_video_play"] ? true : false,
			"video_volume"	=> max(0,$this->tpl_module["settings"]["set_video_volume"]),
			"audio_autoplay"	=> $this->tpl_module["settings"]["set_audio_play"] ? true : false,
			"audio_volume"	=> max(0,$this->tpl_module["settings"]["set_audio_volume"]),
		);

		return $this->_t($template)->blockReplace(
			$blocks[$image["type"]] , 
			$image,
			$settings,
			$this->tpl_module["settings"]
		);
	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Slider($images , $type , $options) {
		global $base;

		$blocks = array(
			"1"	=> "Default",
			"2"	=> "Default",
			"3"	=> "Default",
			"4"	=> "Default",
			"5"	=> "Default",
			"6"	=> "HTML",
			"7"	=> "Default",
		);


		foreach ($images as $key => $image) {
			if ($image["link"]) {
				$image["_link"] = $images[$key]["_link"] = $this->_t("common")->blockReplace(
					"Link" , 
					$image
				);
			} else {
				$image["_link"] = $images[$key]["_link"] = "";
			}

			if ($image["title"]) {
				$images[$key]["_title"] = $this->_t("common")->blockReplace(
					"Title" , 
					$image
				);
			} else {
				$images[$key]["_title"] = "";
			}

			if ($image["copyright"]) {
				$images[$key]["copy"] = $this->_t("common")->blockReplace(
					$image["copyright_link"] ? "CopyrightLink" : "Copyright" , 
					$image
				);
			} else {
				$images[$key]["copy"] = "";
			}

			
			$images[$key]["content"] = $this->_t("slider")->blockReplace(
				$blocks[$image["type"]] , 
				$images[$key]
			);

		}
		
		if ($type == "details") {
			$settings = array(
				"c_auto"	=> $this->tpl_module["settings"]["set_details_carousel_timeout"] ? 1 : 0,
				"c_speed"	=> (int)$this->tpl_module["settings"]["set_details_carousel_timeout"],
				"c_nav"		=> (int)$this->tpl_module["settings"]["set_details_carousel_nav"],
				"c_dots"	=> (int)$this->tpl_module["settings"]["set_details_carousel_dots"],
				"c_height"	=> (int)$this->tpl_module["settings"]["set_details_carousel_height"],
			);
		} else {
			$settings = array(
				"c_auto"	=> $this->tpl_module["settings"]["set_list_carousel_timeout"] ? 1 : 0,
				"c_speed"	=> (int)$this->tpl_module["settings"]["set_list_carousel_timeout"],
				"c_nav"		=> (int)$this->tpl_module["settings"]["set_list_carousel_nav"],
				"c_dots"	=> (int)$this->tpl_module["settings"]["set_list_carousel_dots"],
				"c_height"	=> (int)$this->tpl_module["settings"]["set_list_carousel_height"],
			);
		}
		

		return $this->_t("slider")->blockReplace(
			"Slider",
			array(
				"content"	=> $base->html->table(
					$this->_t("slider"),
					"",
					$images
				)
			),
			$settings,
			array(
				"_before"	=> $options["before"],
				"_after"	=> $options["after"],
			),
			$this->tpl_module["settings"]
		);
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetThumb($parent ,$module , $options = array()) {

		$table = $options["table"] ? $options["table"] : $this->tables["plugin:media"];
		$table_lang = $options["table_lang"] ? $options["table_lang"] : $this->tables["plugin:media_lang"];

		$path = $options["path"] ? $options["path"] : "upload/media";
		$tn	= $options["tn"] ? $options["tn"]	:	"tn";


		$item = $this->db->QFetchArray(
			"
			SELECT *,r.item_id as id, r.module_id as mid FROM 
				{$table} as r
			WHERE
				r.item_parent = {$parent} AND 
				r.module_id = {$module}	AND 
				find_in_set(1 , item_show)
			ORDER BY 
				item_order ASC
			LIMIT 1
			"
		);

		if (is_array($item)) {

			$item["item_id"] = $item["id"];
			$item["module_id"] = $item["mid"];


			switch ($item["item_type"]) {
				//image
				case "1":
					$tn	= "{$path}/{$tn}/{$item[item_id]}.jpg";
				break;

				//yputube
				case "2":
					$tn	= "https://img.youtube.com/vi/" . $item["item_youtube"] . "/mqdefault.jpg";
				break;

				//vimeo
				case "3":
					$tn	= $item["item_vimeo_cover"];
				break;

				default: 
					$tn = "";
				break;
			}

			return $tn;

		}

	
	}
	
	
}

?>